# itu_fttx_plugin/config/constants.py

# ==========================================
# LAYER CONFIGURATION
# ==========================================

# Layers to load into QGIS when connecting to DB
CORE_LAYERS_TO_ADD = [
    # Infrastructure layers (LineString geometry)
    ('itu_cable_routes', 'route_id', 'Cable Routes'),
    ('itu_fiber_cables', 'cable_id', 'Fiber Cables'),
    ('itu_network_paths', 'path_id', 'Network Paths'),
    
    # Equipment layers (Point geometry)
    ('itu_olt_equipment', 'olt_id', 'OLT Equipment'),
    ('itu_odn_nodes', 'node_id', 'ODN Nodes (Splitters)'),
    ('itu_onu_equipment', 'onu_id', 'ONU/ONT Equipment'),
    ('itu_splice_points', 'splice_id', 'Splice Points'),
]

# ==========================================
# DATABASE QUERIES (Partial - only for utilities)
# ==========================================

# Query for AddPONPortDialog
SQL_SELECT_OLTS = """
    SELECT olt_id, olt_code, pon_standard
    FROM fttx.itu_olt_equipment
    WHERE equipment_status = 'operational'
    ORDER BY olt_code
"""

SQL_INSERT_PON_PORT = """
    INSERT INTO fttx.itu_olt_pon_ports (
        olt_id, port_number, port_label, optical_budget_class,
        max_logical_reach_km, max_onus, port_status
    ) VALUES (%s, %s, %s, %s, %s, %s, %s)
"""

# Query for BOM Generator (Example)
SQL_SELECT_OLT_BOM = """
    SELECT 
        COUNT(*) as qty,
        pon_standard,
        manufacturer,
        model
    FROM fttx.itu_olt_equipment
    WHERE equipment_status IN ('planned', 'operational')
    GROUP BY pon_standard, manufacturer, model
"""

# ==========================================
# APPLICATION CONSTANTS
# ==========================================

APP_NAME = 'ITU FTTX Planner'
DEFAULT_HOST = 'localhost'
DEFAULT_PORT = 5432
DEFAULT_DATABASE = 'fiberweave_network'
DEFAULT_USER = 'budget_user'
DEFAULT_SPLITTER_LOSS = {
    '1:2': 3.3, '1:4': 7.3, '1:8': 10.5,
    '1:16': 13.7, '1:32': 17.0, '1:64': 20.5
}