# fiberweave/algorithms/provider.py
"""
FiberWeave Processing Provider
Registers algorithms with QGIS Processing framework
"""

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os


class FiberWeaveProvider(QgsProcessingProvider):
    """Processing provider for FiberWeave algorithms"""
    
    def __init__(self):
        super().__init__()
        self.algs = []
    
    def id(self):
        """Unique provider ID"""
        return 'fiberweave'
    
    def name(self):
        """Human readable name"""
        return 'FiberWeave'
    
    def icon(self):
        """Provider icon"""
        return QIcon()
    
    def loadAlgorithms(self):
        """Load all algorithms"""
        # Import algorithms here to avoid circular imports
        from .validate_network import ValidateNetworkAlgorithm
        from .power_budget_batch import PowerBudgetBatchAlgorithm
        from .export_report import ExportNetworkReportAlgorithm
        
        # Add algorithms
        self.addAlgorithm(ValidateNetworkAlgorithm())
        self.addAlgorithm(PowerBudgetBatchAlgorithm())
        self.addAlgorithm(ExportNetworkReportAlgorithm())
    
    def longName(self):
        """Full provider name"""
        return 'FiberWeave - Professional Fiber Network Planning'
    
    def versionInfo(self):
        """Version information"""
        return '1.0.0'