-- ==========================================
-- AUTO-CODE GENERATION FOR ALL FTTX LAYERS
-- Creates triggers to auto-generate codes for all tables
-- ==========================================

SET search_path TO fttx, public;

-- ==========================================
-- CABLE ROUTES: RTE-0001, RTE-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_route_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.route_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(route_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.itu_cable_routes
        WHERE route_code ~ '^RTE-[0-9]+$';
        
        NEW.route_code := 'RTE-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_route_code ON fttx.itu_cable_routes;
CREATE TRIGGER trg_generate_route_code
    BEFORE INSERT ON fttx.itu_cable_routes
    FOR EACH ROW
    EXECUTE FUNCTION generate_route_code();

-- Update existing routes
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(route_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.itu_cable_routes WHERE route_code ~ '^RTE-[0-9]+$';
    
    FOR v_record IN SELECT route_id FROM fttx.itu_cable_routes WHERE route_code IS NULL ORDER BY route_id
    LOOP
        UPDATE fttx.itu_cable_routes
        SET route_code = 'RTE-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE route_id = v_record.route_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- FIBER CABLES: CBL-0001, CBL-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_cable_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.cable_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(cable_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.itu_fiber_cables
        WHERE cable_code ~ '^CBL-[0-9]+$';
        
        NEW.cable_code := 'CBL-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_cable_code ON fttx.itu_fiber_cables;
CREATE TRIGGER trg_generate_cable_code
    BEFORE INSERT ON fttx.itu_fiber_cables
    FOR EACH ROW
    EXECUTE FUNCTION generate_cable_code();

-- Update existing cables
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(cable_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.itu_fiber_cables WHERE cable_code ~ '^CBL-[0-9]+$';
    
    FOR v_record IN SELECT cable_id FROM fttx.itu_fiber_cables WHERE cable_code IS NULL ORDER BY cable_id
    LOOP
        UPDATE fttx.itu_fiber_cables
        SET cable_code = 'CBL-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE cable_id = v_record.cable_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- OLT EQUIPMENT: OLT-0001, OLT-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_olt_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.olt_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(olt_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.itu_olt_equipment
        WHERE olt_code ~ '^OLT-[0-9]+$';
        
        NEW.olt_code := 'OLT-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_olt_code ON fttx.itu_olt_equipment;
CREATE TRIGGER trg_generate_olt_code
    BEFORE INSERT ON fttx.itu_olt_equipment
    FOR EACH ROW
    EXECUTE FUNCTION generate_olt_code();

-- Update existing OLTs
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(olt_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.itu_olt_equipment WHERE olt_code ~ '^OLT-[0-9]+$';
    
    FOR v_record IN SELECT olt_id FROM fttx.itu_olt_equipment WHERE olt_code IS NULL ORDER BY olt_id
    LOOP
        UPDATE fttx.itu_olt_equipment
        SET olt_code = 'OLT-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE olt_id = v_record.olt_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- ODN NODES: NODE-0001, NODE-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_node_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.node_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(node_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.itu_odn_nodes
        WHERE node_code ~ '^NODE-[0-9]+$';
        
        NEW.node_code := 'NODE-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_node_code ON fttx.itu_odn_nodes;
CREATE TRIGGER trg_generate_node_code
    BEFORE INSERT ON fttx.itu_odn_nodes
    FOR EACH ROW
    EXECUTE FUNCTION generate_node_code();

-- Update existing nodes
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(node_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.itu_odn_nodes WHERE node_code ~ '^NODE-[0-9]+$';
    
    FOR v_record IN SELECT node_id FROM fttx.itu_odn_nodes WHERE node_code IS NULL ORDER BY node_id
    LOOP
        UPDATE fttx.itu_odn_nodes
        SET node_code = 'NODE-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE node_id = v_record.node_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- ONU EQUIPMENT: ONU-0001, ONU-0002, etc.
-- Note: onu_serial_number is the main identifier
-- ==========================================

CREATE OR REPLACE FUNCTION generate_onu_serial()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.onu_serial_number IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(onu_serial_number FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.itu_onu_equipment
        WHERE onu_serial_number ~ '^ONU-[0-9]+$';
        
        NEW.onu_serial_number := 'ONU-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_onu_serial ON fttx.itu_onu_equipment;
CREATE TRIGGER trg_generate_onu_serial
    BEFORE INSERT ON fttx.itu_onu_equipment
    FOR EACH ROW
    EXECUTE FUNCTION generate_onu_serial();

-- Update existing ONUs
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(onu_serial_number FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.itu_onu_equipment WHERE onu_serial_number ~ '^ONU-[0-9]+$';
    
    FOR v_record IN SELECT onu_id FROM fttx.itu_onu_equipment WHERE onu_serial_number IS NULL ORDER BY onu_id
    LOOP
        UPDATE fttx.itu_onu_equipment
        SET onu_serial_number = 'ONU-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE onu_id = v_record.onu_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- SPLICE POINTS: SPL-0001, SPL-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_splice_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.splice_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(splice_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.itu_splice_points
        WHERE splice_code ~ '^SPL-[0-9]+$';
        
        NEW.splice_code := 'SPL-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_splice_code ON fttx.itu_splice_points;
CREATE TRIGGER trg_generate_splice_code
    BEFORE INSERT ON fttx.itu_splice_points
    FOR EACH ROW
    EXECUTE FUNCTION generate_splice_code();

-- Update existing splice points
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(splice_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.itu_splice_points WHERE splice_code ~ '^SPL-[0-9]+$';
    
    FOR v_record IN SELECT splice_id FROM fttx.itu_splice_points WHERE splice_code IS NULL ORDER BY splice_id
    LOOP
        UPDATE fttx.itu_splice_points
        SET splice_code = 'SPL-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE splice_id = v_record.splice_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- NETWORK PATHS: PATH-0001, PATH-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_path_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.path_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(path_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.itu_network_paths
        WHERE path_code ~ '^PATH-[0-9]+$';
        
        NEW.path_code := 'PATH-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_path_code ON fttx.itu_network_paths;
CREATE TRIGGER trg_generate_path_code
    BEFORE INSERT ON fttx.itu_network_paths
    FOR EACH ROW
    EXECUTE FUNCTION generate_path_code();

-- Update existing paths
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(path_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.itu_network_paths WHERE path_code ~ '^PATH-[0-9]+$';
    
    FOR v_record IN SELECT path_id FROM fttx.itu_network_paths WHERE path_code IS NULL ORDER BY path_id
    LOOP
        UPDATE fttx.itu_network_paths
        SET path_code = 'PATH-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE path_id = v_record.path_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- INSIDE PLANT: ROOMS - RM-0001, RM-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_room_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.room_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(room_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.rooms
        WHERE room_code ~ '^RM-[0-9]+$';
        
        NEW.room_code := 'RM-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_room_code ON fttx.rooms;
CREATE TRIGGER trg_generate_room_code
    BEFORE INSERT ON fttx.rooms
    FOR EACH ROW
    EXECUTE FUNCTION generate_room_code();

-- Update existing rooms
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(room_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.rooms WHERE room_code ~ '^RM-[0-9]+$';
    
    FOR v_record IN SELECT room_id FROM fttx.rooms WHERE room_code IS NULL ORDER BY room_id
    LOOP
        UPDATE fttx.rooms
        SET room_code = 'RM-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE room_id = v_record.room_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- RACKS: RACK-0001, RACK-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_rack_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.rack_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(rack_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.racks
        WHERE rack_code ~ '^RACK-[0-9]+$';
        
        NEW.rack_code := 'RACK-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_rack_code ON fttx.racks;
CREATE TRIGGER trg_generate_rack_code
    BEFORE INSERT ON fttx.racks
    FOR EACH ROW
    EXECUTE FUNCTION generate_rack_code();

-- Update existing racks
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(rack_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.racks WHERE rack_code ~ '^RACK-[0-9]+$';
    
    FOR v_record IN SELECT rack_id FROM fttx.racks WHERE rack_code IS NULL ORDER BY rack_id
    LOOP
        UPDATE fttx.racks
        SET rack_code = 'RACK-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE rack_id = v_record.rack_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- RACK EQUIPMENT: EQP-0001, EQP-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_equipment_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.equipment_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(equipment_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.rack_equipment
        WHERE equipment_code ~ '^EQP-[0-9]+$';
        
        NEW.equipment_code := 'EQP-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_equipment_code ON fttx.rack_equipment;
CREATE TRIGGER trg_generate_equipment_code
    BEFORE INSERT ON fttx.rack_equipment
    FOR EACH ROW
    EXECUTE FUNCTION generate_equipment_code();

-- Update existing equipment
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(equipment_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.rack_equipment WHERE equipment_code ~ '^EQP-[0-9]+$';
    
    FOR v_record IN SELECT equipment_id FROM fttx.rack_equipment WHERE equipment_code IS NULL ORDER BY equipment_id
    LOOP
        UPDATE fttx.rack_equipment
        SET equipment_code = 'EQP-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE equipment_id = v_record.equipment_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- EQUIPMENT PORTS: PORT-0001, PORT-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_port_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.port_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(port_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.equipment_ports
        WHERE port_code ~ '^PORT-[0-9]+$';
        
        NEW.port_code := 'PORT-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_port_code ON fttx.equipment_ports;
CREATE TRIGGER trg_generate_port_code
    BEFORE INSERT ON fttx.equipment_ports
    FOR EACH ROW
    EXECUTE FUNCTION generate_port_code();

-- Update existing ports
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(port_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.equipment_ports WHERE port_code ~ '^PORT-[0-9]+$';
    
    FOR v_record IN SELECT port_id FROM fttx.equipment_ports WHERE port_code IS NULL ORDER BY port_id
    LOOP
        UPDATE fttx.equipment_ports
        SET port_code = 'PORT-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE port_id = v_record.port_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- PATCH PANELS: PNL-0001, PNL-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_panel_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.panel_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(panel_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.patch_panels
        WHERE panel_code ~ '^PNL-[0-9]+$';
        
        NEW.panel_code := 'PNL-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_panel_code ON fttx.patch_panels;
CREATE TRIGGER trg_generate_panel_code
    BEFORE INSERT ON fttx.patch_panels
    FOR EACH ROW
    EXECUTE FUNCTION generate_panel_code();

-- Update existing panels
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(panel_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.patch_panels WHERE panel_code ~ '^PNL-[0-9]+$';
    
    FOR v_record IN SELECT panel_id FROM fttx.patch_panels WHERE panel_code IS NULL ORDER BY panel_id
    LOOP
        UPDATE fttx.patch_panels
        SET panel_code = 'PNL-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE panel_id = v_record.panel_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- PATCH CONNECTIONS: CONN-0001, CONN-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_connection_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.connection_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(connection_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.patch_connections
        WHERE connection_code ~ '^CONN-[0-9]+$';
        
        NEW.connection_code := 'CONN-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_connection_code ON fttx.patch_connections;
CREATE TRIGGER trg_generate_connection_code
    BEFORE INSERT ON fttx.patch_connections
    FOR EACH ROW
    EXECUTE FUNCTION generate_connection_code();

-- Update existing connections
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(connection_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.patch_connections WHERE connection_code ~ '^CONN-[0-9]+$';
    
    FOR v_record IN SELECT connection_id FROM fttx.patch_connections WHERE connection_code IS NULL ORDER BY connection_id
    LOOP
        UPDATE fttx.patch_connections
        SET connection_code = 'CONN-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE connection_id = v_record.connection_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- CABLE PATHWAYS: PWY-0001, PWY-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_pathway_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.pathway_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(pathway_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.cable_pathways
        WHERE pathway_code ~ '^PWY-[0-9]+$';
        
        NEW.pathway_code := 'PWY-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_pathway_code ON fttx.cable_pathways;
CREATE TRIGGER trg_generate_pathway_code
    BEFORE INSERT ON fttx.cable_pathways
    FOR EACH ROW
    EXECUTE FUNCTION generate_pathway_code();

-- Update existing pathways
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(pathway_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.cable_pathways WHERE pathway_code ~ '^PWY-[0-9]+$';
    
    FOR v_record IN SELECT pathway_id FROM fttx.cable_pathways WHERE pathway_code IS NULL ORDER BY pathway_id
    LOOP
        UPDATE fttx.cable_pathways
        SET pathway_code = 'PWY-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE pathway_id = v_record.pathway_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- TEST RESULTS: TST-0001, TST-0002, etc.
-- ==========================================

CREATE OR REPLACE FUNCTION generate_test_code()
RETURNS TRIGGER AS $$
DECLARE
    v_next_num INTEGER;
BEGIN
    IF NEW.test_code IS NULL THEN
        SELECT COALESCE(MAX(CAST(SUBSTRING(test_code FROM '[0-9]+') AS INTEGER)), 0) + 1
        INTO v_next_num
        FROM fttx.test_results
        WHERE test_code ~ '^TST-[0-9]+$';
        
        NEW.test_code := 'TST-' || LPAD(v_next_num::TEXT, 4, '0');
    END IF;
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS trg_generate_test_code ON fttx.test_results;
CREATE TRIGGER trg_generate_test_code
    BEFORE INSERT ON fttx.test_results
    FOR EACH ROW
    EXECUTE FUNCTION generate_test_code();

-- Update existing test results
DO $$
DECLARE
    v_record RECORD;
    v_counter INTEGER := 1;
BEGIN
    SELECT COALESCE(MAX(CAST(SUBSTRING(test_code FROM '[0-9]+') AS INTEGER)), 0) + 1
    INTO v_counter FROM fttx.test_results WHERE test_code ~ '^TST-[0-9]+$';
    
    FOR v_record IN SELECT test_id FROM fttx.test_results WHERE test_code IS NULL ORDER BY test_id
    LOOP
        UPDATE fttx.test_results
        SET test_code = 'TST-' || LPAD(v_counter::TEXT, 4, '0')
        WHERE test_id = v_record.test_id;
        v_counter := v_counter + 1;
    END LOOP;
END $$;

-- ==========================================
-- SUMMARY
-- ==========================================

DO $$ 
DECLARE
    v_route_count INTEGER;
    v_cable_count INTEGER;
    v_olt_count INTEGER;
    v_node_count INTEGER;
    v_onu_count INTEGER;
    v_building_count INTEGER;
BEGIN
    SELECT COUNT(*) INTO v_route_count FROM fttx.itu_cable_routes;
    SELECT COUNT(*) INTO v_cable_count FROM fttx.itu_fiber_cables;
    SELECT COUNT(*) INTO v_olt_count FROM fttx.itu_olt_equipment;
    SELECT COUNT(*) INTO v_node_count FROM fttx.itu_odn_nodes;
    SELECT COUNT(*) INTO v_onu_count FROM fttx.itu_onu_equipment;
    SELECT COUNT(*) INTO v_building_count FROM fttx.buildings;
    
    RAISE NOTICE '';
    RAISE NOTICE '=================================================================';
    RAISE NOTICE '✓ AUTO-CODE GENERATION TRIGGERS CREATED FOR ALL LAYERS!';
    RAISE NOTICE '=================================================================';
    RAISE NOTICE '';
    RAISE NOTICE 'Code Formats Created:';
    RAISE NOTICE '  • Cable Routes:     RTE-0001, RTE-0002, ...  (% records)', v_route_count;
    RAISE NOTICE '  • Fiber Cables:     CBL-0001, CBL-0002, ...  (% records)', v_cable_count;
    RAISE NOTICE '  • OLT Equipment:    OLT-0001, OLT-0002, ...  (% records)', v_olt_count;
    RAISE NOTICE '  • ODN Nodes:        NODE-0001, NODE-0002, ... (% records)', v_node_count;
    RAISE NOTICE '  • ONU Equipment:    ONU-0001, ONU-0002, ...  (% records)', v_onu_count;
    RAISE NOTICE '  • Buildings:        BLD-0001, BLD-0002, ...  (% records)', v_building_count;
    RAISE NOTICE '  • Splice Points:    SPL-0001, SPL-0002, ...';
    RAISE NOTICE '  • Network Paths:    PATH-0001, PATH-0002, ...';
    RAISE NOTICE '  • Rooms:            RM-0001, RM-0002, ...';
    RAISE NOTICE '  • Racks:            RACK-0001, RACK-0002, ...';
    RAISE NOTICE '  • Equipment:        EQP-0001, EQP-0002, ...';
    RAISE NOTICE '  • Ports:            PORT-0001, PORT-0002, ...';
    RAISE NOTICE '  • Patch Panels:     PNL-0001, PNL-0002, ...';
    RAISE NOTICE '  • Connections:      CONN-0001, CONN-0002, ...';
    RAISE NOTICE '  • Pathways:         PWY-0001, PWY-0002, ...';
    RAISE NOTICE '  • Test Results:     TST-0001, TST-0002, ...';
    RAISE NOTICE '';
    RAISE NOTICE 'Features:';
    RAISE NOTICE '  ✓ All existing records updated with codes';
    RAISE NOTICE '  ✓ Triggers created for automatic generation';
    RAISE NOTICE '  ✓ Sequential numbering maintained';
    RAISE NOTICE '  ✓ Codes will auto-generate when creating new features in QGIS';
    RAISE NOTICE '';
    RAISE NOTICE 'Next Steps:';
    RAISE NOTICE '  1. Update fttx_layer_styles.py to make code fields read-only';
    RAISE NOTICE '  2. Reload QGIS plugin';
    RAISE NOTICE '  3. Apply styles';
    RAISE NOTICE '  4. Test by creating new features';
    RAISE NOTICE '=================================================================';
END $$;

-- Grant permissions
GRANT EXECUTE ON ALL FUNCTIONS IN SCHEMA fttx TO PUBLIC;